//
//  PTAutomatorWorkflow.h
//
//  Created by Quentin Carnicelli on 5/21/05.
//  Copyright 2005 Rogue Amoeba Software, LLC. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface PTAutomatorWorkflow : NSObject
{
	NSString* mWorkflowPath;
}

+ (BOOL)automatorSupported;
+ (BOOL)isWorkflowFile: (NSString*)path;

+ (NSError*)executeWorkflow: (NSString*)workflowPath withFiles: (NSArray*)filePaths;

- (id)initWithWorkflowFile: (NSString*)workflowPath;

- (NSError*)executeWithFiles: (NSArray*)filePaths;

@end
